from numpy import zeros, array, product, diagonal
from math import *
#from scipy import linalg
from gaussElimin import *
from LUdecomp import *

#defines vandermode matrix for the l
def vandermode(v):
    n = len(v)
    a = zeros((n,n))
    for j in range(n):
        a[:,j] = v**(n-j-1)
    return a

# x- coordinates of interpolation points
v = array([1.0, 1.2, 1.4, 1.6, 1.8, 2.0])
print 'v =\n',v

#coefficent matrix
A = vandermode(v)
print 'A =\n',A

#right hand side of the system  y coordinates of the interpolation points
b = array([0.0, 1.0, 0.0, 1.0, 0.0, 1.0])

save_a = A.copy()
save_b = b.copy()

u = LUdecomp(A)
det = product(diagonal(u))
print 'H orizousa einai: det=\n',det

if det != 0 :
    x = LUsolve(u,b)
    print 'H lush einai: x =\n',x
else :
    print '\nTo sustima den exei monadiki lush'
    
n = len(v)
I = zeros((n,n))
for i in range(n):
    for j in range(n):
        if i == j :
            I[i, j] = 1
        else:
            I[i, j] = 0
            
Ant = zeros((n,n))
print 'O antistrofos einai:\n'
for i in range(n):
   Ant[i] = LUsolve(u,I[i])
print Ant